FoldableSuspension = {
	MOD_NAME = g_currentModName,
	SPEC_NAME = g_currentModName .. ".foldableSuspension",
	SPEC_TBL_NAME = "spec_" .. g_currentModName .. ".foldableSuspension",
	prerequisitesPresent = function (specializations)
		return SpecializationUtil.hasSpecialization(Foldable, specializations) and SpecializationUtil.hasSpecialization(Suspensions, specializations)
	end,
	initSpecialization = function ()
		local schema = Vehicle.xmlSchema

		schema:setXMLSpecializationType("FoldableSuspension")
		schema:register(XMLValueType.FLOAT, "vehicle.suspensions.suspension(?)#foldMinLimit", "Min. fold time to be active", 0)
		schema:register(XMLValueType.FLOAT, "vehicle.suspensions.suspension(?)#foldMaxLimit", "Max. fold time to be active", 1)
		schema:setXMLSpecializationType()
	end,
	registerFunctions = function (vehicleType)
	end
}

function FoldableSuspension.registerOverwrittenFunctions(vehicleType)
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "getIsSuspensionNodeActive", FoldableSuspension.getIsSuspensionNodeActive)
end

function FoldableSuspension.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", FoldableSuspension)
end

function FoldableSuspension:onPostLoad(savegame)
	if self.isClient then
		local spec = self.spec_suspensions

		self.xmlFile:iterate("vehicle.suspensions.suspension", function (index, key)
			local node = self.xmlFile:getValue(key .. "#node", nil, self.components, self.i3dMappings)

			if node ~= nil then
				for i = 1, #spec.suspensionNodes do
					local suspensionNode = spec.suspensionNodes[i]

					if suspensionNode.node == node then
						suspensionNode.foldMinLimit = self.xmlFile:getValue(key .. "#foldMinLimit", 0)
						suspensionNode.foldMaxLimit = self.xmlFile:getValue(key .. "#foldMaxLimit", 1)
					end
				end
			end
		end)
	end
end

function FoldableSuspension:getIsSuspensionNodeActive(superFunc, suspensionNode)
	if not superFunc(self, suspensionNode) then
		return false
	end

	local foldAnimTime = self.spec_foldable.foldAnimTime

	if foldAnimTime ~= nil and (suspensionNode.foldMaxLimit < foldAnimTime or foldAnimTime < suspensionNode.foldMinLimit) then
		return false
	end

	return true
end