TrailerExtension = {
	MOD_NAME = g_currentModName,
	SPEC_NAME = g_currentModName .. ".trailerExtension"
}
TrailerExtension.SPEC_TABLE_NAME = "spec_" .. TrailerExtension.SPEC_NAME

function TrailerExtension.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Trailer, specializations)
end

function TrailerExtension.initSpecialization()
	local schema = Vehicle.xmlSchema

	schema:setXMLSpecializationType("TrailerExtension")

	local key = "vehicle.trailer.trailerConfigurations.trailerConfiguration(?).trailer"

	schema:register(XMLValueType.FLOAT, key .. ".folding#minLimit", "Min. folding time to allow tipping", 0)
	schema:register(XMLValueType.FLOAT, key .. ".folding#maxLimit", "Max. folding time to allow tipping", 1)
	schema:register(XMLValueType.BOOL, key .. "#allowFoldingWhileTipping", "Allow folding while vehicle is tipping", false)
	schema:setXMLSpecializationType()
end

function TrailerExtension.registerFunctions(vehicleType)
end

function TrailerExtension.registerOverwrittenFunctions(vehicleType)
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "getCanDischargeToGround", TrailerExtension.getCanDischargeToGround)
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "getCanDischargeToObject", TrailerExtension.getCanDischargeToObject)
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "getDischargeNotAllowedWarning", TrailerExtension.getDischargeNotAllowedWarning)
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "getIsFoldAllowed", TrailerExtension.getIsFoldAllowed)
end

function TrailerExtension.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", TrailerExtension)
end

function TrailerExtension:onLoad(savegame)
	local spec = self.spec_trailer
	local trailerConfigurationId = Utils.getNoNil(self.configurations.trailer, 1)
	local configKey = string.format("vehicle.trailer.trailerConfigurations.trailerConfiguration(%d).trailer", trailerConfigurationId - 1)
	spec.foldMinLimit = self.xmlFile:getValue(configKey .. ".folding#minLimit", 0)
	spec.foldMaxLimit = self.xmlFile:getValue(configKey .. ".folding#maxLimit", 1)
	spec.allowFoldingWhileTipping = self.xmlFile:getValue(configKey .. "#allowFoldingWhileTipping", false)
	spec.foldingWarning = g_i18n:getText("warning_foldingNotWhileTurnedOn")
end

function TrailerExtension:getCanDischargeToGround(superFunc, dischargeNode)
	if not superFunc(self, dischargeNode) then
		return false
	end

	local spec = self.spec_trailer
	local spec_foldable = self.spec_foldable

	if spec_foldable ~= nil then
		local foldAnimTime = spec_foldable.foldAnimTime

		if foldAnimTime ~= nil and (spec.foldMaxLimit < foldAnimTime or foldAnimTime < spec.foldMinLimit) then
			return false
		end
	end

	return true
end

function TrailerExtension:getCanDischargeToObject(superFunc, dischargeNode)
	if not superFunc(self, dischargeNode) then
		return false
	end

	local spec = self.spec_trailer
	local spec_foldable = self.spec_foldable

	if spec_foldable ~= nil then
		local foldAnimTime = spec_foldable.foldAnimTime

		if foldAnimTime ~= nil and (spec.foldMaxLimit < foldAnimTime or foldAnimTime < spec.foldMinLimit) then
			return false
		end
	end

	return true
end

function TrailerExtension:getDischargeNotAllowedWarning(superFunc, dischargeNode)
	local spec = self.spec_trailer
	local spec_foldable = self.spec_foldable

	if spec_foldable ~= nil then
		local foldAnimTime = spec_foldable.foldAnimTime

		if foldAnimTime ~= nil and (spec.foldMaxLimit < foldAnimTime or foldAnimTime < spec.foldMinLimit) then
			return spec_foldable.unfoldWarning
		end
	end

	return superFunc(self, dischargeNode)
end

function TrailerExtension:getIsFoldAllowed(superFunc, direction, onAiTurnOn)
	local isAllowed, warning = superFunc(self, direction, onAiTurnOn)

	if not isAllowed then
		return isAllowed, warning
	end

	local spec = self.spec_trailer

	if not spec.allowFoldingWhileTipping and self:getTipState() ~= Trailer.TIPSTATE_CLOSED then
		return false, spec.foldingWarning
	end

	return true
end