PushHandToolExtensionDriveModeEvent = {}
local PushHandToolExtensionDriveModeEvent_mt = Class(PushHandToolExtensionDriveModeEvent, Event)

InitEventClass(PushHandToolExtensionDriveModeEvent, "PushHandToolExtensionDriveModeEvent")

function PushHandToolExtensionDriveModeEvent.emptyNew()
	local self = Event.new(PushHandToolExtensionDriveModeEvent_mt)

	return self
end

function PushHandToolExtensionDriveModeEvent.new(object, driveModeState)
	local self = PushHandToolExtensionDriveModeEvent.emptyNew()
	self.object = object
	self.driveModeState = driveModeState

	return self
end

function PushHandToolExtensionDriveModeEvent:readStream(streamId, connection)
	self.object = NetworkUtil.readNodeObject(streamId)
	self.driveModeState = streamReadBool(streamId)

	self:run(connection)
end

function PushHandToolExtensionDriveModeEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.object)
	streamWriteBool(streamId, self.driveModeState)
end

function PushHandToolExtensionDriveModeEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object)
	end

	if self.object ~= nil and self.object:getIsSynchronized() then
		self.object:setPushHandToolDriveMode(self.driveModeState, true)
	end
end

function PushHandToolExtensionDriveModeEvent.sendEvent(vehicle, driveModeState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(PushHandToolExtensionDriveModeEvent.new(vehicle, driveModeState), nil, _, vehicle)
		else
			g_client:getServerConnection():sendEvent(PushHandToolExtensionDriveModeEvent.new(vehicle, driveModeState))
		end
	end
end