--|
--| [ Quick Selector ]
--|
--| @author			Quity - T. Florin
--| @Description:	Quick Selector Module - Dialogs
--|
--| Copyright (C) - T. Florin, All Rights Reserved.
--|
function QuickSelector.Dialogs.init(QS, Hud, Vem, Actions, ConfigGui, I18n, Utility, Dialogs)
   local storedCrossHairVisibility;
   local storedPickUpCrossHairVisibility;
   Dialogs.activeDialog = nil;
   function Dialogs:render()
      Dialogs.activeDialog:render();
   end
   function Dialogs:hideCrossHairs()
      if g_localPlayer then
         storedCrossHairVisibility = g_localPlayer.hands.spec_hands.crosshair.visible;
         storedPickUpCrossHairVisibility = g_localPlayer.hands.spec_hands.pickUpCrosshair.visible;
         g_localPlayer.hands.spec_hands.crosshair.visible = false;
         g_localPlayer.hands.spec_hands.pickUpCrosshair.visible = false;
         g_localPlayer:setCurrentHandTool(nil, true);
      end
   end
   function Dialogs:resetCrossHairs()
      if g_localPlayer then
         g_localPlayer.hands.spec_hands.crosshair.visible = storedCrossHairVisibility;
         g_localPlayer.hands.spec_hands.pickUpCrosshair.visible = storedPickUpCrossHairVisibility;
      end
   end
   Dialogs.general = {};
   function Dialogs.general:new(id, title, config)
      local self = setmetatable({}, Class(Dialogs.general));
      local _, headerHeight = getNormalizedScreenValues(0, 34);
      local _, footerHeight = getNormalizedScreenValues(0, 38);
      local closeBtnWidth, closeBtnHeight = getNormalizedScreenValues(26, 26);
      local headerAndFooterExtraY = 0.01;
      local width, height = getNormalizedScreenValues(config.body.w, config.body.h);
      local startPosX = config.body.x - width / 2;
      local startPosY = config.body.y - height / 2;
      self.activeButtonsList = {};
      self.Colors = {
         backdropBg = {0.01, 0.01, 0.01, 0.8},
         bodyBg = {0.02, 0.02, 0.02, 0.96},
         headerBg = {0.01, 0.01, 0.01, 1},
         footerBg = {0.01, 0.01, 0.01, 1},
      };
      self.backdrop = { posX = 0, posY = 0, width = 1, height = 1 };
      self.body = { posX = startPosX, posY = startPosY, width = width, height = height };
      self.contentStartY = startPosY + footerHeight;
      self.contentEndY = startPosY + height - headerHeight;
      self.header = {
         posX = startPosX,
         posY = self.body.posY + self.body.height - headerHeight + headerAndFooterExtraY,
         width = width,
         height = headerHeight,
         heightPercent = headerHeight / 100,
         title = I18n:getName(title),
         textSize = getCorrectTextSize(0.015),
      };
      local closeBtnMarginX, closeBtnMarginY = getNormalizedScreenValues(8, 8);
      local closeBtnPosX = self.header.posX + self.header.width - closeBtnWidth - closeBtnMarginX;
      local closeBtnPosY = self.header.posY + self.header.height - closeBtnHeight - closeBtnMarginY;
      self.header.closeBtn = Hud:createBtn(0, false, true, false, closeBtnPosX, closeBtnPosY, closeBtnWidth, closeBtnHeight, 0, 9, "configHeaderCloseBtn", {
         internalContext = config.internalContext,
         bgColor = QS.Const.defaultGameColor,
         onClickCallback = function(btn)
            btn.overlayBg:setColor(table.unpack(QS.Const.activeClickColor));
            self:close();
         end,
         onLeftClickCallback = function(btn)
            btn.overlayBg:setColor(table.unpack(QS.Const.defaultGameColor));
         end,
         onHoverCallback = function(btn)
            btn.overlayBg:setColor(table.unpack(QS.Const.defaultGameColorShade0_2));
         end,
         onLeftHoverCallback = function(btn)
            btn.overlayBg:setColor(table.unpack(QS.Const.defaultGameColor));
         end,
         overlayBg = Utility.newColoredOverlay(QS.assetsDir .. "general/closeHud.dds", closeBtnPosX, closeBtnPosY, closeBtnWidth, closeBtnHeight, QS.Const.defaultGameColor),
      });
      table.insert(self.activeButtonsList, self.header.closeBtn);
      function _createFooterElements()
         local list = {};
         local textSize = getCorrectTextSize(0.014);
         local _, btnPadding = getNormalizedScreenValues(0, 14);
         local btnSpacing = getNormalizedScreenValues(12, 0);
         local btnHeight = self.footer.height - self.footer.heightPercent * 32;
         local updatedStartPosX = 0.5; 
         local centerBtnsTotalSize = 0;
         for _, btnConfig in ipairs(config.buttons) do
            centerBtnsTotalSize = centerBtnsTotalSize + (getTextWidth(textSize, btnConfig.name) + btnPadding + btnSpacing);
         end
         updatedStartPosX = updatedStartPosX - ((centerBtnsTotalSize- btnSpacing) / 2); 
         for index, btnConfig in ipairs(config.buttons) do
            local btnWidth = getTextWidth(textSize, btnConfig.name) + btnPadding;
            list[index] = Hud:createBtn(index, false, true, false, updatedStartPosX, self.footer.posY + self.footer.heightPercent * 26, btnWidth, btnHeight, 0, 9, btnConfig.name, {
               internalContext = config.internalContext,
               bgColor = QS.Const.defaultGameColor,
               callback = btnConfig.callback,
               onClickCallback = function(btn)
                  btn.bgColor = QS.Const.activeClickColor;
                  btn.callback(self);
               end,
               onLeftClickCallback = function(btn)
                  btn.bgColor = btn.isHovered and QS.Const.defaultGameColorShade0_2 or QS.Const.defaultGameColor;
               end,
               onHoverCallback = function(btn)
                  btn.bgColor = QS.Const.defaultGameColorShade0_2;
               end,
               onLeftHoverCallback = function(btn)
                  btn.bgColor = QS.Const.defaultGameColor;
               end,
               renderBtn = function(btn)
                  drawFilledRectRound(btn.posX, btn.posY, btn.width, btn.height, 0.2, table.unpack(btn.bgColor));
                  setTextAlignment(RenderText.ALIGN_CENTER);
                  setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_MIDDLE);
                  setTextBold(true);
                  setTextColor(table.unpack(QS.Const.fullWhiteColor));
                  renderText(btn.posX + btn.width / 2, btn.posY + btn.height / 2 + (btn.height * 0.05), textSize, btn.name);
               end
            });
            table.insert(self.activeButtonsList, list[index]);
            updatedStartPosX = updatedStartPosX + btnWidth + btnSpacing;
         end
         return list;
      end
      self.footer = {
         posX = startPosX,
         posY = startPosY - headerAndFooterExtraY,
         width = self.body.width,
         height = footerHeight,
         heightPercent = footerHeight / 100,
      };
      self.footer.elements = _createFooterElements();
      function self:close()
         if config.callbacks and config.callbacks.close then
            config.callbacks.close(self);
         end
         self:delete();
      end
      function self:delete()
         Dialogs:resetCrossHairs();
         Hud:removeItemsFromGrid(self.activeButtonsList);
         Hud:setInternalContext();
         if Dialogs.activeDialog == self then
            Dialogs.activeDialog = nil;
         end
      end
      function self:render()
         if config.hasBackdrop then
            drawFilledRect(self.backdrop.posX, self.backdrop.posY, self.backdrop.width, self.backdrop.height, table.unpack(self.Colors.backdropBg));
         end
         drawFilledRectRound(self.body.posX, self.body.posY, self.body.width, self.body.height, 0.5, table.unpack(self.Colors.bodyBg));
         drawFilledRectRound(self.header.posX, self.header.posY, self.header.width, self.header.height, 0.5, table.unpack(self.Colors.headerBg));
         drawFilledRect(self.header.posX, self.header.posY - (self.header.heightPercent * 25), self.header.width, self.header.height, table.unpack(self.Colors.headerBg));
         setTextAlignment(RenderText.ALIGN_CENTER);
         setTextBold(true);
         setTextColor(table.unpack(QS.Const.fullWhiteColor));
         renderText(0.5, self.header.posY + (self.header.heightPercent * 15), self.header.textSize, self.header.title);
         self.header.closeBtn.overlayBg:render();
         if config.contentText then
            setTextWrapWidth(self.body.width - (self.body.width * 0.1));
            renderText(config.body.x, config.body.y, getCorrectTextSize(0.014), config.contentText);
            setTextWrapWidth(0);
         end
         drawFilledRectRound(self.footer.posX, self.footer.posY, self.footer.width, self.footer.height, 0.5, table.unpack(self.Colors.footerBg));
         drawFilledRect(self.footer.posX, self.footer.posY + (self.footer.heightPercent * 25), self.footer.width, self.footer.height, table.unpack(self.Colors.footerBg));
         for _, btn in ipairs(self.footer.elements) do
            btn:renderBtn();
         end
         if config.callbacks and config.callbacks.renderContent then
            config.callbacks.renderContent(self);
         end
      end
      Dialogs:hideCrossHairs();
      Hud:setInternalContext(config.internalContext); 
      Dialogs.activeDialog = self;
      return self;
   end
end