--|
--| [ Quick Selector ]
--|
--| @author			Quity - T. Florin
--| @Description:	Quick Selector Module - Utility
--|
--| Copyright (C) - T. Florin, All Rights Reserved.
--|
function QuickSelector.Utility.init(QS, Utility)
   function Utility.unpackTableValues(inputTable)
      local values = {};
      for _, value in pairs(inputTable) do
         table.insert(values, value)
      end
      return table.unpack(values);
   end
   function Utility.unpackColor(colorTable, customAlpha)
      local r, g, b, alpha = table.unpack(colorTable);
      return r, g, b, customAlpha or alpha;
   end
   function Utility.sanitizeText(text)
      return text and text:gsub("[\r\n]+", " ") or "";
   end
   function Utility.toConstantCase(str)
      return str:gsub("(%l)(%u)", "%1_%2"):upper();
   end
   function Utility.newColoredOverlay(asset, posX, posY, width, height, colorsTable)
      local overlay = Overlay.new(asset, posX, posY, width, height);
      overlay:setColor(table.unpack(colorsTable));
      return overlay;
   end
   return Utility;
end
